/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.volcano;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_5138;
import net.minecraft.class_5216;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5866;
import net.minecraft.class_6005;
import net.minecraft.class_6625;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.stateproviders.BetweenNoiseThresholdProvider;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;
import potionstudios.byg.common.world.structure.BYGStructurePieceTypes;
import potionstudios.byg.common.world.structure.volcano.VolcanoStructure;

public class VolcanoPiece
extends class_3443 {
    private final VolcanoStructure.PieceStructureInfo structureInfo;

    protected VolcanoPiece(VolcanoStructure.PieceStructureInfo structureInfo, int genDepth, class_3341 boundingBox) {
        super(BYGStructurePieceTypes.VOLCANO_PIECE.get(), genDepth, boundingBox);
        this.structureInfo = structureInfo;
    }

    public VolcanoPiece(class_6625 context, class_2487 tag) {
        super(BYGStructurePieceTypes.ARCH_PIECE.get(), tag);
        this.structureInfo = (VolcanoStructure.PieceStructureInfo)((Pair)VolcanoStructure.PieceStructureInfo.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("volcano_info")).result().orElseThrow()).getFirst();
    }

    protected void method_14943(class_6625 context, class_2487 compoundTag) {
        compoundTag.method_10566("volcano_info", (class_2520)VolcanoStructure.PieceStructureInfo.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.structureInfo).result().orElseThrow());
    }

    public void method_14931(class_5281 worldGenLevel, class_5138 structureManager, class_2794 chunkGenerator, class_5819 randomSource, class_3341 boundingBox, class_1923 chunkPos, class_2338 blockPos) {
        BetweenNoiseThresholdProvider weightedBlockStateProvider = new BetweenNoiseThresholdProvider(123L, new class_5216.class_5487(-9, 1.0, new double[]{1.0, 1.0, 1.0}), 1.0f, List.of(class_5866.method_33934((float)-0.90449995f, (float)-0.8955f), class_5866.method_33934((float)-0.0045f, (float)0.0045f)), (class_4651)class_4651.method_38432((class_2248)class_2246.field_10092), (class_4651)new class_4657(class_6005.method_34971().method_34975((Object)class_2246.field_22091.method_9564(), 9).method_34975((Object)BYGBlocks.BLACK_SAND.defaultBlockState(), 2).method_34975((Object)class_2246.field_28888.method_9564(), 5).method_34975((Object)class_2246.field_29032.method_9564(), 10).method_34974()), false);
        double baseRadius = this.structureInfo.baseRadius();
        double leakage = this.structureInfo.leakage();
        int volcanoConeSize = this.structureInfo.volcanoConeSize();
        int volcanoStartHeight = this.structureInfo.volcanoStartHeight();
        double threshold = 0.35;
        int maxY = this.structureInfo.maxY();
        int baseHeight = this.structureInfo.origin().method_10264();
        int fluidYOffset = this.structureInfo.fluidY();
        FastNoiseLite fastNoiseLite = FastNoiseLite.createSpongePerlin(this.structureInfo.noiseSeed());
        fastNoiseLite.SetFrequency(0.05f);
        class_2338 subtract = this.structureInfo.origin().method_10069(-volcanoConeSize, 0, -volcanoConeSize);
        int startX = subtract.method_10263();
        int startZ = subtract.method_10260();
        class_2338 add = this.structureInfo.origin().method_10069(volcanoConeSize, 0, volcanoConeSize);
        int endX = add.method_10263();
        int endZ = add.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int minX = Math.max(startX, chunkPos.method_8326());
        int maxX = Math.min(endX, chunkPos.method_8327());
        int minZ = Math.max(startZ, chunkPos.method_8328());
        int maxZ = Math.min(endZ, chunkPos.method_8329());
        for (int worldX = minX; worldX <= maxX; ++worldX) {
            int localX = worldX - this.structureInfo.origin().method_10263();
            for (int worldZ = minZ; worldZ <= maxZ; ++worldZ) {
                int localZ = worldZ - this.structureInfo.origin().method_10260();
                for (double y = (double)(-volcanoConeSize); y <= (double)maxY; y += 1.0) {
                    mutable.method_10102((double)worldX, (double)baseHeight + y + (double)volcanoStartHeight, (double)worldZ);
                    float spongePerlinValue = FastNoiseLite.getSpongePerlinValue(fastNoiseLite.GetNoise(mutable.method_10263(), mutable.method_10260()));
                    double scaledNoise = (double)(spongePerlinValue / 13.0f) * (-(y * baseRadius) / (double)(localX * localX + localZ * localZ));
                    int fluidY = maxY - fluidYOffset;
                    double lava = scaledNoise - leakage - leakage / 2.0 - 0.5;
                    double crater = scaledNoise - 0.05;
                    if (lava >= threshold) {
                        if (y <= (double)fluidY) {
                            worldGenLevel.method_30092((class_2338)mutable, class_2246.field_10164.method_9564(), 2, 1);
                        }
                    } else if (crater >= threshold) {
                        double pct = threshold / crater;
                        double craterY = class_3532.method_15390((double)maxY, (double)fluidY, (double)(1.0 - pct));
                        if (y <= craterY) {
                            worldGenLevel.method_30092((class_2338)mutable, weightedBlockStateProvider.method_23455(randomSource, (class_2338)mutable), 2, 1);
                        }
                    } else if (scaledNoise >= threshold) {
                        worldGenLevel.method_30092((class_2338)mutable, weightedBlockStateProvider.method_23455(randomSource, (class_2338)mutable), 2, 1);
                    }
                    mutable.method_10098(class_2350.field_11033);
                }
            }
        }
    }
}

